package fr.umlv.lgextract.table;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;

import fr.umlv.lgextract.exceptions.LGExtractException;
import fr.umlv.lgextract.exceptions.LGExtractNoEntryException;

public class LGTransposedTable implements LGTable {
  private List<List<String>> tab = new ArrayList<List<String>>();
  private HashMap<String,Integer> properties = new HashMap<String,Integer>();
  private int STARTING_COL = 1;
  private int rowId = 0;
  private HashMap<String,String> tableValues;

  
    public LGTransposedTable(String name,List<HSSFSheet> sheets,HashMap<String,String> values){
    	this.tableValues = values;
    	for(HSSFSheet sheet:sheets){
        	  readSheet(sheet);
        }   
    	//System.out.println(tab.get(0).size());
    	//System.out.println(tab.get(1).size());
    	//System.out.println(tab.get(22));
    }
    
    private void readSheet(HSSFSheet sheet){
		HSSFRow row = null;
		Iterator rowIt = sheet.rowIterator();
		rowIt.next();
		int propId = 0;
		while(rowIt.hasNext()){			
    		row = (HSSFRow)rowIt.next();
    		Iterator cells = row.cellIterator();
    		int i = 0;
        	while(cells.hasNext()){        		
        		HSSFCell cell = (HSSFCell)cells.next();
        		
        		if(i == STARTING_COL){
        			properties.put(cell.toString(), propId);
        			tab.add(new ArrayList<String>());
        		}
        		if(i > STARTING_COL){
        			//if(!cell.toString().isEmpty()){
             		   tab.get(propId).add(cell.toString());
             		   //System.err.println(cell.toString());   		   
             		//}        		
             		} 
        		i++;        		
        	}
    		propId++;
    		//System.err.println("**************");
    	}
    	//System.out.print(properties);
    	//System.out.println("***************"+properties.size());
	}
  
	public Set<String> getProperties() {
		return properties.keySet();
	}

	public int getRowID() {
		return rowId;
	}

	public String getValue(String property) throws LGExtractException,
			LGExtractNoEntryException {
		
		Integer propId = properties.get(property);
		if(propId == null) return "false";
		String s = tab.get(propId).get(getRowID() - 1);
		String val = this.tableValues.get(s);
		if(val == null){
			return s;
		}
		return val;
		/*if(s.equals("+")) {
			return "true";}
		if(s.equals("?+")) return "true";
		if(s.equals("?-")) return "false";
		if(s.equals("-")) return "false";
		if(s.equals("?")) return "false";
		if(s.equals("0")) return "false";
		return s;*/
	}

	public String getValue(String property, boolean tableOfTablesOnly)
			throws LGExtractException, LGExtractNoEntryException {
		return getValue(property);
	}

	public boolean hasNext() {
		return (rowId < tab.get(0).size());
	}

	public void next() {
		rowId++;

	}

}
