/**
 * 
 *
 * Software: LGExtract
 * Authors: Matthieu Constant and Elsa Tolone
 *
 * Copyright (C) 2010-2011 Université Paris-Est Marne-la-Vallée
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA.
 *
 */

package fr.umlv.lgextract.table;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

import jxl.Sheet;
import jxl.Workbook;
import jxl.WorkbookSettings;
import jxl.read.biff.BiffException;
import fr.umlv.lgextract.LGExtract;
import fr.umlv.lgextract.LGExtractEnvironment;

/**
 * 
 * @author Matthieu Constant
 *
 */


public class LGTableOfTables extends LGAbstractTableOfTables {
  public final static String ID_PROPERTY="<ID>";
  final private HashMap<String,String> tableValues;
  final private HashMap<String, Integer> tableIds = new HashMap<String, Integer>();
  final private Sheet sheet;
  final private int startingCol;
  final private int startingRow;
  
  
    public LGTableOfTables(LGExtractEnvironment env,HashMap<String,String> values) throws IndexOutOfBoundsException, IOException, BiffException{
    	this.tableValues = values;
	    File file = new File(env.getTableOfTables());
	    if(!file.exists()){
	    	throw new IOException("Table of tables "+file+" does not exist!");
	    }	    
	    WorkbookSettings ws = new WorkbookSettings();
	    ws.setSuppressWarnings(true);
	    ws.setEncoding(LGTable.EXCEL_ENCODING);
		this.sheet = Workbook.getWorkbook(file,ws).getSheet(0);
		this.startingCol = env.getHeaderColumn();
		this.startingRow = env.getHeaderRow();
		loadProperties();
		loadTableIds();
    }

    private void loadTableIds(){
    	int tableRow = getPropertyId(LGExtract.TABLE_ID_PROPERTY);
    	for(int i = startingCol ; i < sheet.getColumns() ; i++){
    		//System.out.println(i+"=>"+sheet.getCell(startingCol,i).getContents());
    		tableIds.put(sheet.getCell(i,tableRow).getContents(), i);
    	}
    }
    
    
    private void loadProperties(){
    	for(int i = startingRow ; i < sheet.getRows() ; i++){
    		//System.out.println(i+"=>"+sheet.getCell(startingCol,i).getContents());
    		properties.put(sheet.getCell(startingCol,i).getContents(), i);
    	}
    }
    
    

	public LGTableEntry getTableEntry(String tableName) {
		Integer propId = getPropertyId(LGExtract.TABLE_ID_PROPERTY);
		if(propId == null){
			return null;
		}		
		
		return new LGTableOfTablesEntry(tableIds.get(tableName), this);
	}


	@Override
	public String getIdProperty() {
		return ID_PROPERTY;
	}


	@Override
	public String getName() {
		return null;
	}


	@Override
	public Set<String> getProperties() {
		return properties.keySet();
	}


	@Override
	public Integer getPropertyId(String property) {		
		return properties.get(property);
	}


	@Override
	public Sheet getSheet() {
		return sheet;
	}


	@Override
	public LGTableOfTables getTableOfTables() {
		return null;
	}


	@Override
	public Iterator<LGAbstractTableOfTablesEntry> iterator() {
		return new Iterator<LGAbstractTableOfTablesEntry>() {
			int colId = startingCol + 1; 
			
			@Override
			public boolean hasNext() {
				return colId < sheet.getColumns();
			}

			@Override
			public LGAbstractTableOfTablesEntry next() {
				colId++;
				return new LGTableOfTablesEntry(colId-1,LGTableOfTables.this);
			}

			@Override
			public void remove() {
			}
			
		};
	}

	@Override
	public Map<String, String> getValues() {		
		return tableValues;
	}
    
    
    
    

}
