/**
 * 
 *
 * Software: LGExtract
 * Authors: Matthieu Constant and Elsa Tolone
 *
 * Copyright (C) 2010-2011 Université Paris-Est Marne-la-Vallée
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA.
 *
 */
package fr.umlv.lgextract.table;

import java.util.ArrayList;

import fr.umlv.lgextract.exceptions.LGExtractException;
import fr.umlv.lgextract.exceptions.LGExtractNoEntryException;

/**
 * @author Matthieu Constant
 *
 */
public class LGCsvTableOfTablesEntry extends LGAbstractTableOfTablesEntry {
	final private ArrayList<String> cells = new ArrayList<String>();  
		
	public LGCsvTableOfTablesEntry(int rowId, LGTable<?> table) {
		super(rowId, table);
	}
     
	
	public void addProp(String value){
		cells.add(value);
	}
	
	
	/* (non-Javadoc)
	 * @see fr.umlv.lgextract.table.LGTableEntry#getValue(java.lang.String, boolean)
	 */
	@Override
	public String getValue(String property, boolean tableOfTablesOnly)
			throws LGExtractException, LGExtractNoEntryException {
		Integer propId = table.getPropertyId(property);
		if(propId == null){ 
			throw new LGExtractException("Property "+property + " does not exist!");
		}		
		String s = cells.get(propId);
		//System.err.println("TDT: "+property+"=>"+s);
		String val = table.getValues().get(s);
		if(val == null){
			return s;
		}
		return val;

	}

}
