/**
 * 
 *
 * Software: LGExtract
 * Authors: Matthieu Constant and Elsa Tolone
 *
 * Copyright (C) 2010-2011 Université Paris-Est Marne-la-Vallée
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA.
 *
 */

package fr.umlv.lgextract;



import java.io.IOException;
import java.io.OutputStream;
import java.util.List;

import org.jdom.Comment;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

import fr.umlv.lgextract.lobjects.LingObj;
import fr.umlv.lgextract.table.LGAbstractNormalTableEntry;

/**
 * 
 * @author Matthieu Constant
 *
 */

public class LGExtractXMLWriter implements LGExtractWriter{
	private final Element root;
	private final Document doc;
	private final OutputStream output;
	private  final XMLOutputter serializer = new XMLOutputter();
	
	public LGExtractXMLWriter(Element root,OutputStream output)throws IOException{
		this.root = root;
		doc = new Document(root);
	    serializer.setFormat(Format.getPrettyFormat());
	    this.output = output;	    
	}
	
	@Override
	public void writeEntry(List<LingObj> list,LGExtractFormatting formatting,LGAbstractNormalTableEntry entry) throws IOException{
		Element e = new Element("entry");
		root.addContent(e);		
		e.setAttribute("id",""+entry.getTable().getName()+"_"+entry.getEntryId());
		String status = COMPLETED_STATUS;
		if(entry.isToEncode()){
			status = TO_ENCODE_STATUS;
		}
		else {
			if(entry.isToComplete()){
			  status = TO_COMPLETE_STATUS;
		   }
		}
		e.setAttribute("status",status);
		for(LingObj o:list){
			o.toXML(e,formatting);
		}
		//serializer.output(e, output);
	}
	
	@Override
	public void writeNoEntry(LGAbstractNormalTableEntry entry) throws IOException{
		root.addContent(new Comment("Entry "+entry.getTable().getName()+"_"+ entry.getEntryId() + " is not encoded !"));
		//serializer.output(, output);
	}
	
	public void close() throws IOException{
		serializer.output(doc, output);
	}
	
}
