/**
 * 
 *
 * Software: LGExtract
 * Authors: Matthieu Constant and Elsa Tolone
 *
 * Copyright (C) 2010-2011 Université Paris-Est Marne-la-Vallée
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA.
 *
 */

package fr.umlv.lgextract;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

import jxl.Workbook;
import jxl.WorkbookSettings;
import jxl.read.biff.BiffException;
import jxl.write.Label;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;
import jxl.write.WriteException;
import jxl.write.biff.RowsExceededException;
import fr.umlv.lgextract.table.LGNormalTable;
import fr.umlv.lgextract.table.LGTable;

/**
 * 
 * @author Matthieu Constant
 *
 */


public class LGExtractTableOfTables {

	/**
	 * @param args
	 */

	private static File[]  readList(String path){
		File f = new File(path);
		FilenameFilter fnf = new FilenameFilter(){

			public boolean accept(File arg0, String arg1) {
				return arg1.endsWith(".lgt.xls");
			}

		};
		return f.listFiles(fnf);
	}

	


	private static void createTable(String pathname,Collection<LGNormalTable> tables) throws IndexOutOfBoundsException, IOException, RowsExceededException, WriteException {
		HashSet<String> properties = new HashSet<String>();
		WorkbookSettings ws = new WorkbookSettings();
	    ws.setEncoding(LGTable.EXCEL_ENCODING);
		WritableWorkbook wb = Workbook.createWorkbook(new File(pathname),ws);
		WritableSheet sheet = wb.createSheet("TDT", 0);;
		Label label = new Label(0, 0, "table");
		sheet.addCell(label);
		int i = 1;
		for(LGNormalTable table:tables){
			properties.addAll(table.getProperties());
			sheet.addCell(new Label(i, 0, table.getName()));
			i++;
		}
		LinkedList<String> lproperties = new LinkedList<String>(properties);
		Collections.sort(lproperties);
		i = 1;		
		for(String prop:lproperties){
			sheet.addCell(new Label(0, i, prop));
			int j = 1;
		   	for(LGNormalTable table:tables){
		   		String val = table.getProperties().contains(prop)?"o":"?";
		   		sheet.addCell(new Label(j, i, val));
		   		j++;
		   	}
		   	i++;
		}		
		wb.write();
		wb.close();
		
		
		/*
		for(i = 0 ; i < n ; i++){
			tmp = lists.get(i);
			System.out.print("table");
			for(String prop:tmp){				
				System.out.print("\t"+prop);
			}
			System.out.println();
			for(String name:tableProperties.keySet()){
				System.out.print(name);			    
				for(String prop:tmp){
					if(tableProperties.get(name).contains(prop)){
						System.out.print("\t"+"o");
					}
					else{
						System.out.print("\t"+"?");
					}
				}
				System.out.println();			    
			}			
		}
		*/


	}
	
	
	public static void main(String[] args) throws IOException, IndexOutOfBoundsException, BiffException, RowsExceededException, WriteException{
		if(args.length != 2){
			System.err.println("Usage: java LGExtractTableOfTables <dirpath of tables> <output xls file>");
			System.exit(1);
		}
		List<LGNormalTable> tables = new LinkedList<LGNormalTable>();
		File[] list = readList(args[0]);
		
		Arrays.sort(list, new Comparator<File>() {

			@Override
			public int compare(File o1, File o2) {				
				return o1.toString().compareTo(o2.toString());
			}
		});
		Set<String> set = new HashSet<String>();
		HashMap<String, Set<String>> tableProperties = new HashMap<String, Set<String>>();
		for(File f:list){
			String name = f.getAbsolutePath();
			//System.out.println(name);
			LGNormalTable t = new LGNormalTable(name,null,null,false);
			tables.add(t);
			name = name.substring(name.lastIndexOf("/")+1,name.length() - 8);
			tableProperties.put(name, t.getProperties());
			set.addAll(t.getProperties());		
		}
		createTable(args[1],tables);

		//System.err.println(tableProperties);
		//System.err.println(tableProperties.keySet().size());
		//System.err.println(set.size());
		//printTables(set,tableProperties);

	}

}
