package fr.umlv.lgextract.tools;

import fr.umlv.tatoo.runtime.ast.FlatNode;
import fr.umlv.tatoo.runtime.ast.Node;
import fr.umlv.tatoo.runtime.ast.Node.NoValue;
import fr.umlv.tatoo.runtime.ast.NodeVisitor;
import java.io.Serializable;

public class Prop extends FlatNode<Node,Node,NoValue> implements Serializable {
  Prop() {
    // used by XML serialization
  }
  public Prop(IActionname actionname, Instruction_Star instruction_star) {
    setActionname(actionname);
    setInstruction_star(instruction_star);
  }
  
  /** 
   * {@inheritDoc}
   */
  public String getName() {
    return "prop";
  }
  
  public IActionname getActionname() {
    return actionname;
  }
  public void setActionname(IActionname actionname) {
    this.actionname= reparent(this.actionname,actionname);
  }
  public Instruction_Star getInstruction_star() {
    return instruction_star;
  }
  public void setInstruction_star(Instruction_Star instruction_star) {
    this.instruction_star= reparent(this.instruction_star,instruction_star);
  }
  /** 
   * {@inheritDoc}
   */
  @Override
  protected Class<Node> getElementType() {
    return Node.class;
  }
  /** 
   * {@inheritDoc}
   */
  @Override
  protected int nodeCount() {
    return 2;
  }
  
  /** 
   * {@inheritDoc}
   */
  @Override
  protected Node nodeAt(int index) {
    switch(index) {
          case 0:
        return this.actionname;
          case 1:
        return this.instruction_star;
        }
    return super.nodeAt(index);
  }
  
  /** 
   * {@inheritDoc}
   */
  @Override
  protected Node nodeAt(int index, Node node) {
    Node old;
    switch(index) {
            case 0:
        old=this.actionname;
        setActionname( (IActionname) node);
        return old;
            case 1:
        old=this.instruction_star;
        setInstruction_star( (Instruction_Star) node);
        return old;
          }
    return super.nodeAt(index,node);
  }
  
  /** 
   * {@inheritDoc}
   */
  public <_R,_P,_D,_E extends Throwable> _R accept(NodeVisitor<_R,_P,_D,_E> visitor,_P param) throws _E {
    return accept((Visitor<_R,_P,_D,_E>)visitor,param);
  }
  
  public <_R,_P,_D,_E extends Throwable> _R accept(Visitor<_R,_P,_D,_E> visitor,_P param) throws _E {
    return visitor.visit(this,param);
  }
  
  private IActionname actionname;
  private Instruction_Star instruction_star;

  private static final long serialVersionUID=2363496861942098984L;
}

