package fr.umlv.lgextract.tools;

import fr.umlv.lgextract.tools.IBoolexp;
import fr.umlv.tatoo.runtime.ast.FlatNode;
import fr.umlv.tatoo.runtime.ast.Node;
import fr.umlv.tatoo.runtime.ast.Node.NoValue;
import fr.umlv.tatoo.runtime.ast.NodeVisitor;
import java.io.Serializable;

public class Not extends FlatNode<IBoolexp,Node,NoValue> implements Serializable, IBoolexp {
  Not() {
    // used by XML serialization
  }
  public Not(IBoolexp boolexp) {
    setBoolexp(boolexp);
  }
  
  /** 
   * {@inheritDoc}
   */
  public String getName() {
    return "not";
  }
  
  public IBoolexp getBoolexp() {
    return boolexp;
  }
  public void setBoolexp(IBoolexp boolexp) {
    this.boolexp= reparent(this.boolexp,boolexp);
  }
  /** 
   * {@inheritDoc}
   */
  @Override
  protected Class<IBoolexp> getElementType() {
    return IBoolexp.class;
  }
  /** 
   * {@inheritDoc}
   */
  @Override
  protected int nodeCount() {
    return 1;
  }
  
  /** 
   * {@inheritDoc}
   */
  @Override
  protected IBoolexp nodeAt(int index) {
    switch(index) {
          case 0:
        return this.boolexp;
        }
    return super.nodeAt(index);
  }
  
  /** 
   * {@inheritDoc}
   */
  @Override
  protected IBoolexp nodeAt(int index, IBoolexp node) {
    IBoolexp old;
    switch(index) {
            case 0:
        old=this.boolexp;
        setBoolexp( node);
        return old;
          }
    return super.nodeAt(index,node);
  }
  
  /** 
   * {@inheritDoc}
   */
  public <_R,_P,_D,_E extends Throwable> _R accept(NodeVisitor<_R,_P,_D,_E> visitor,_P param) throws _E {
    return accept((Visitor<_R,_P,_D,_E>)visitor,param);
  }
  
  public <_R,_P,_D,_E extends Throwable> _R accept(Visitor<_R,_P,_D,_E> visitor,_P param) throws _E {
    return visitor.visit(this,param);
  }
  
  private IBoolexp boolexp;

  private static final long serialVersionUID=5858709846661654930L;
}

