package fr.umlv.lgextract.tools;

import fr.umlv.lgextract.tools.Information_Star;
import fr.umlv.tatoo.runtime.ast.FlatNode;
import fr.umlv.tatoo.runtime.ast.Node;
import fr.umlv.tatoo.runtime.ast.Node.NoValue;
import fr.umlv.tatoo.runtime.ast.NodeVisitor;
import java.io.Serializable;

public class Infos extends FlatNode<Information_Star,Node,NoValue> implements Serializable {
  Infos() {
    // used by XML serialization
  }
  public Infos(Information_Star information_star) {
    setInformation_star(information_star);
  }
  
  /** 
   * {@inheritDoc}
   */
  public String getName() {
    return "infos";
  }
  
  public Information_Star getInformation_star() {
    return information_star;
  }
  public void setInformation_star(Information_Star information_star) {
    this.information_star= reparent(this.information_star,information_star);
  }
  /** 
   * {@inheritDoc}
   */
  @Override
  protected Class<Information_Star> getElementType() {
    return Information_Star.class;
  }
  /** 
   * {@inheritDoc}
   */
  @Override
  protected int nodeCount() {
    return 1;
  }
  
  /** 
   * {@inheritDoc}
   */
  @Override
  protected Information_Star nodeAt(int index) {
    switch(index) {
          case 0:
        return this.information_star;
        }
    return super.nodeAt(index);
  }
  
  /** 
   * {@inheritDoc}
   */
  @Override
  protected Information_Star nodeAt(int index, Information_Star node) {
    Information_Star old;
    switch(index) {
            case 0:
        old=this.information_star;
        setInformation_star( node);
        return old;
          }
    return super.nodeAt(index,node);
  }
  
  /** 
   * {@inheritDoc}
   */
  public <_R,_P,_D,_E extends Throwable> _R accept(NodeVisitor<_R,_P,_D,_E> visitor,_P param) throws _E {
    return accept((Visitor<_R,_P,_D,_E>)visitor,param);
  }
  
  public <_R,_P,_D,_E extends Throwable> _R accept(Visitor<_R,_P,_D,_E> visitor,_P param) throws _E {
    return visitor.visit(this,param);
  }
  
  private Information_Star information_star;

  private static final long serialVersionUID=1056834670413356420L;
}

