package fr.umlv.lgextract.tools;

import fr.umlv.lgextract.tools.ISimplefs;
import fr.umlv.tatoo.runtime.ast.FlatNode;
import fr.umlv.tatoo.runtime.ast.Node;
import fr.umlv.tatoo.runtime.ast.Node.NoValue;
import fr.umlv.tatoo.runtime.ast.NodeVisitor;
import java.io.Serializable;

public class Fs_Simple extends FlatNode<ISimplefs,Node,NoValue> implements Serializable, IFs {
  Fs_Simple() {
    // used by XML serialization
  }
  public Fs_Simple(ISimplefs simplefs) {
    setSimplefs(simplefs);
  }
  
  /** 
   * {@inheritDoc}
   */
  public String getName() {
    return "fs-simple";
  }
  
  public ISimplefs getSimplefs() {
    return simplefs;
  }
  public void setSimplefs(ISimplefs simplefs) {
    this.simplefs= reparent(this.simplefs,simplefs);
  }
  /** 
   * {@inheritDoc}
   */
  @Override
  protected Class<ISimplefs> getElementType() {
    return ISimplefs.class;
  }
  /** 
   * {@inheritDoc}
   */
  @Override
  protected int nodeCount() {
    return 1;
  }
  
  /** 
   * {@inheritDoc}
   */
  @Override
  protected ISimplefs nodeAt(int index) {
    switch(index) {
          case 0:
        return this.simplefs;
        }
    return super.nodeAt(index);
  }
  
  /** 
   * {@inheritDoc}
   */
  @Override
  protected ISimplefs nodeAt(int index, ISimplefs node) {
    ISimplefs old;
    switch(index) {
            case 0:
        old=this.simplefs;
        setSimplefs( node);
        return old;
          }
    return super.nodeAt(index,node);
  }
  
  /** 
   * {@inheritDoc}
   */
  public <_R,_P,_D,_E extends Throwable> _R accept(NodeVisitor<_R,_P,_D,_E> visitor,_P param) throws _E {
    return accept((Visitor<_R,_P,_D,_E>)visitor,param);
  }
  
  public <_R,_P,_D,_E extends Throwable> _R accept(Visitor<_R,_P,_D,_E> visitor,_P param) throws _E {
    return visitor.visit(this,param);
  }
  
  private ISimplefs simplefs;

  private static final long serialVersionUID=-9036032693583527121L;
}

