package fr.umlv.lgextract.tools;

import fr.umlv.lgextract.tools.IFeature;
import fr.umlv.tatoo.runtime.ast.FlatNode;
import fr.umlv.tatoo.runtime.ast.Node;
import fr.umlv.tatoo.runtime.ast.Node.NoValue;
import fr.umlv.tatoo.runtime.ast.NodeVisitor;
import java.io.Serializable;

public class Features_Feature extends FlatNode<IFeature,Node,NoValue> implements Serializable, IFeatures {
  Features_Feature() {
    // used by XML serialization
  }
  public Features_Feature(IFeature feature) {
    setFeature(feature);
  }
  
  /** 
   * {@inheritDoc}
   */
  public String getName() {
    return "features-feature";
  }
  
  public IFeature getFeature() {
    return feature;
  }
  public void setFeature(IFeature feature) {
    this.feature= reparent(this.feature,feature);
  }
  /** 
   * {@inheritDoc}
   */
  @Override
  protected Class<IFeature> getElementType() {
    return IFeature.class;
  }
  /** 
   * {@inheritDoc}
   */
  @Override
  protected int nodeCount() {
    return 1;
  }
  
  /** 
   * {@inheritDoc}
   */
  @Override
  protected IFeature nodeAt(int index) {
    switch(index) {
          case 0:
        return this.feature;
        }
    return super.nodeAt(index);
  }
  
  /** 
   * {@inheritDoc}
   */
  @Override
  protected IFeature nodeAt(int index, IFeature node) {
    IFeature old;
    switch(index) {
            case 0:
        old=this.feature;
        setFeature( node);
        return old;
          }
    return super.nodeAt(index,node);
  }
  
  /** 
   * {@inheritDoc}
   */
  public <_R,_P,_D,_E extends Throwable> _R accept(NodeVisitor<_R,_P,_D,_E> visitor,_P param) throws _E {
    return accept((Visitor<_R,_P,_D,_E>)visitor,param);
  }
  
  public <_R,_P,_D,_E extends Throwable> _R accept(Visitor<_R,_P,_D,_E> visitor,_P param) throws _E {
    return visitor.visit(this,param);
  }
  
  private IFeature feature;

  private static final long serialVersionUID=7148757620846702954L;
}

