package fr.umlv.lgextract.tools;

import fr.umlv.lgextract.tools.IBoolexp;
import fr.umlv.tatoo.runtime.ast.FlatNode;
import fr.umlv.tatoo.runtime.ast.Node;
import fr.umlv.tatoo.runtime.ast.NodeVisitor;
import java.io.Serializable;

public class Create_Conditional extends FlatNode<IBoolexp,Node,String> implements Serializable, IAction {
  Create_Conditional() {
    // used by XML serialization
  }
  public Create_Conditional(String id, IBoolexp boolexp) {
    setId(id);
    setBoolexp(boolexp);
  }
  
  /** 
   * {@inheritDoc}
   */
  public String getName() {
    return "create-conditional";
  }
  
  public IBoolexp getBoolexp() {
    return boolexp;
  }
  public void setBoolexp(IBoolexp boolexp) {
    this.boolexp= reparent(this.boolexp,boolexp);
  }
  public String getId() {
    return id;
  }
  public void setId(String id) {
    this.id=id;
  }
  /** 
   * {@inheritDoc}
   */
  @Override
  protected Class<IBoolexp> getElementType() {
    return IBoolexp.class;
  }
  /** 
   * {@inheritDoc}
   */
  @Override
  protected int nodeCount() {
    return 1;
  }
  
  /** 
   * {@inheritDoc}
   */
  @Override
  protected IBoolexp nodeAt(int index) {
    switch(index) {
          case 0:
        return this.boolexp;
        }
    return super.nodeAt(index);
  }
  
  /** 
   * {@inheritDoc}
   */
  @Override
  protected IBoolexp nodeAt(int index, IBoolexp node) {
    IBoolexp old;
    switch(index) {
            case 0:
        old=this.boolexp;
        setBoolexp( node);
        return old;
          }
    return super.nodeAt(index,node);
  }
  /** 
   * {@inheritDoc}
   */
  @Override
  protected int attributeCount() {
    return 1;
  }
  
  /** 
   * {@inheritDoc}
   */
  @Override
  protected String attributeAt(int index) {
    switch(index) {
          case 0:
        return this.id;
        }
    return super.attributeAt(index);
  }
  
  /** 
   * {@inheritDoc}
   */
  @Override
  @SuppressWarnings("unchecked")
  protected String attributeAt(int index,String value) {
    String old;
    switch(index) {
            case 0:
        old=this.id;
        setId( value);
        return old;
          }    
    return super.attributeAt(index,value);
  }
  
  /** 
   * {@inheritDoc}
   */
  @Override
  protected String attributeNameAt(int index) {
    switch(index) {
          case 0:
        return "id";
        }
    return super.attributeNameAt(index);
  }
  
  /** 
   * {@inheritDoc}
   */
  @Override
  protected Class<? extends String> attributeTypeAt(int index) {
    switch(index) {
          case 0:
        return String.class;
        }
    return super.attributeTypeAt(index);
  }
  
  /** 
   * {@inheritDoc}
   */
  public <_R,_P,_D,_E extends Throwable> _R accept(NodeVisitor<_R,_P,_D,_E> visitor,_P param) throws _E {
    return accept((Visitor<_R,_P,_D,_E>)visitor,param);
  }
  
  public <_R,_P,_D,_E extends Throwable> _R accept(Visitor<_R,_P,_D,_E> visitor,_P param) throws _E {
    return visitor.visit(this,param);
  }
  
  private String id;
  private IBoolexp boolexp;

  private static final long serialVersionUID=6821475934379349307L;
}

