package fr.umlv.lgextract.tools;

import fr.umlv.lgextract.tools.GrammarEvaluator;

public class ASTEvaluator implements GrammarEvaluator {
  public ILingobj obj_feature( String id, String value) {    
    return new Obj_Feature( id, value);
  }
  public Prop prop( IActionname actionname, Instruction_Star instruction_star) {    
    return new Prop( actionname, instruction_star);
  }
  public Header_Module header_module() {    
    return new Header_Module();
  }
  public IBoolvalue prop_value( String propname) {    
    return new Prop_Value( propname);
  }
  public ILingobj obj_fs( IFs fs) {    
    return new Obj_Fs( fs);
  }
  public IBoolexp not( IBoolexp boolexp) {    
    return new Not( boolexp);
  }
  public IAction create_conditional( String id, IBoolexp boolexp) {    
    return new Create_Conditional( id, boolexp);
  }
  public IAction add( String id, IPath path) {    
    return new Add( id, path);
  }
  public Attrib attrib( String id) {    
    return new Attrib( id);
  }
  public IFeature feature_list( String id, IList list) {    
    return new Feature_List( id, list);
  }
  public IFs fs_simple( ISimplefs simplefs) {    
    return new Fs_Simple( simplefs);
  }
  public IBoolexp value( IBoolvalue boolvalue) {    
    return new Value( boolvalue);
  }
  public IActionname propactionname( String propname) {    
    return new Propactionname( propname);
  }
  public IFeatures features_feature( IFeature feature) {    
    return new Features_Feature( feature);
  }
  public IFeatures several_features( IFeature feature, IFeatures features) {    
    return new Several_Features( feature, features);
  }
  public IList empty_list() {    
    return new Empty_List();
  }
  public IActionname not_propactionname( String propname) {    
    return new Not_Propactionname( propname);
  }
  public Define define( String id, String id2, ILingobj lingobj) {    
    return new Define( id, id2, lingobj);
  }
  public IBoolvalue value_id( String id) {    
    return new Value_Id( id);
  }
  public ISimplefs simplefs( IFeatures features) {    
    return new Simplefs( features);
  }
  public IFeature feature_value( String id, String value) {    
    return new Feature_Value( id, value);
  }
  public Infos infos( Information_Star information_star) {    
    return new Infos( information_star);
  }
  public IInstruction actionInstruction( IAction action) {    
    return new ActionInstruction( action);
  }
  public IActionname otherActionName( String id) {    
    return new OtherActionName( id);
  }
  public IBoolexp or( IBoolexp boolexp, IBoolexp boolexp2) {    
    return new Or( boolexp, boolexp2);
  }
  public ISimplefs empty_simplefs() {    
    return new Empty_Simplefs();
  }
  public IBoolexp parenthesis( IBoolexp boolexp) {    
    return new Parenthesis( boolexp);
  }
  public IActionname propactionname_always( String propname) {    
    return new Propactionname_Always( propname);
  }
  public IPath simple_path( String id) {    
    return new Simple_Path( id);
  }
  public IInstruction otherPropCall( String id) {    
    return new OtherPropCall( id);
  }
  public Start start( Header_Module header_module, Infos infos, Define_Star define_star, Property_Star property_star, Element_Star element_star) {    
    return new Start( header_module, infos, define_star, property_star, element_star);
  }
  public IList list( IFeatures features) {    
    return new List( features);
  }
  public IFeature feature_name( String id) {    
    return new Feature_Name( id);
  }
  public IAction create( String id) {    
    return new Create( id);
  }
  public IBoolvalue value_bool( String val) {    
    return new Value_Bool( val);
  }
  public IFeature feature_fs_inherits( String id, ISimplefs simplefs) {    
    return new Feature_Fs_Inherits( id, simplefs);
  }
  public Elem elem( String id, String id2, Att_Star att_star) {    
    return new Elem( id, id2, att_star);
  }
  public IBoolexp and( IBoolexp boolexp, IBoolexp boolexp2) {    
    return new And( boolexp, boolexp2);
  }
  public IPath several_path( String id, IPath path) {    
    return new Several_Path( id, path);
  }
  public IFs fs_inherits( String id, ISimplefs simplefs) {    
    return new Fs_Inherits( id, simplefs);
  }
  public ILingobj obj_list( IList list) {    
    return new Obj_List( list);
  }
  public Info info( String id, String value) {    
    return new Info( id, value);
  }
  public IAction add_conditional( String id, IPath path, IBoolexp boolexp) {    
    return new Add_Conditional( id, path, boolexp);
  }
  public IFeature feature_fs( String id, ISimplefs simplefs) {    
    return new Feature_Fs( id, simplefs);
  }
    
  public Start getStart() {
    return start;
  }
  
  public void acceptStart(Start start) {
    this.start=start;
  }
  private Start start;
}
