/*
 * Decompiled with CFR 0.152.
 */
package fr.umlv.tatoo.runtime.util;

import fr.umlv.tatoo.runtime.util.ReadOnlyIntStack;

public class IntArrayList
implements ReadOnlyIntStack {
    private int[] data;
    private int height = 0;

    public IntArrayList(int initialCapacity) {
        this.data = new int[initialCapacity];
    }

    public IntArrayList() {
        this(10);
    }

    public IntArrayList duplicate() {
        IntArrayList list = new IntArrayList(this.height);
        System.arraycopy(this.data, 0, list.data, 0, this.height);
        list.height = this.height;
        return list;
    }

    public void add(int value) {
        if (this.height == this.data.length) {
            int[] newData = new int[this.data.length * 2];
            System.arraycopy(this.data, 0, newData, 0, this.data.length);
            this.data = newData;
        }
        this.data[this.height] = value;
        ++this.height;
    }

    public void removeLast(int number) {
        assert (number <= this.height) : "empty stack";
        this.height -= number;
    }

    public int removeLast() {
        --this.height;
        return this.data[this.height];
    }

    public int last() {
        assert (this.height > 0) : "empty stack";
        return this.data[this.height - 1];
    }

    public void clear() {
        this.height = 0;
    }

    public int get(int index) {
        return this.data[index];
    }

    public void set(int index, int value) {
        this.data[index] = value;
    }

    public int size() {
        return this.height;
    }

    public boolean isEmpty() {
        return this.height == 0;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(this.height * 3);
        for (int i = 0; i < this.height; ++i) {
            builder.append(this.data[i]).append(',');
        }
        if (this.height != 0) {
            builder.setLength(builder.length() - 1);
        }
        return builder.toString();
    }
}

