/*
 * Decompiled with CFR 0.152.
 */
package fr.umlv.tatoo.runtime.tools.builder;

import fr.umlv.tatoo.runtime.parser.BranchingParserListener;
import fr.umlv.tatoo.runtime.parser.DefaultParserErrorRecoveryPolicy;
import fr.umlv.tatoo.runtime.parser.DefaultParserWarningReporter;
import fr.umlv.tatoo.runtime.parser.ErrorRecoveryListener;
import fr.umlv.tatoo.runtime.parser.LookaheadMap;
import fr.umlv.tatoo.runtime.parser.Parser;
import fr.umlv.tatoo.runtime.parser.ParserErrorRecoveryPolicy;
import fr.umlv.tatoo.runtime.parser.ParserListener;
import fr.umlv.tatoo.runtime.parser.ParserTable;
import fr.umlv.tatoo.runtime.parser.SimpleParser;
import fr.umlv.tatoo.runtime.tools.LookaheadMapFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParserBuilder<T, N, P, V> {
    private final ParserTable<T, N, P, V> table;
    private ParserListener<? super T, ? super N, ? super P> listener;
    private BranchingParserListener<? super T> branchingListener;
    private ParserErrorRecoveryPolicy<T, N, P, V> policy;
    private N start;
    private V version;
    private LookaheadMap<? extends T, ? super V> lookaheadMap;
    private ErrorRecoveryListener<? super T, ? super N> parserErrorRecoveryListener;
    private static final ParserListener<Object, Object, Object> defaultParserListener = new ParserListener<Object, Object, Object>(){

        @Override
        public void shift(Object terminal) {
            System.err.println("shifting terminal " + terminal);
        }

        @Override
        public void reduce(Object production) {
            System.err.println("reducing by production " + production);
        }

        @Override
        public void accept(Object nonTerminal) {
            System.err.println("accept");
        }
    };

    public static <T, N, P, V> ParserBuilder<T, N, P, V> createParserBuilder(ParserTable<T, N, P, V> table) {
        return new ParserBuilder<T, N, P, V>(table);
    }

    protected ParserBuilder(ParserTable<T, N, P, V> table) {
        if (table == null) {
            throw new IllegalArgumentException("table is null");
        }
        this.table = table;
    }

    public Parser<T, N, P, V> createParser() {
        if (this.listener == null) {
            this.listener = defaultParserListener;
        }
        if (this.policy == null) {
            this.policy = this.createDefaultParserErrorRecoveryPolicy();
        }
        if (this.start == null) {
            this.start = this.table.getDefaultStart();
        }
        if (this.version == null) {
            this.version = this.table.getDefaultVersion();
        }
        Parser<? super T, N, P, V> parser = Parser.createParser(this.table, this.listener, this.policy, this.start, this.version, this.lookaheadMap);
        if (this.branchingListener != null) {
            parser.setBranchingParserListener(this.branchingListener);
        }
        return parser;
    }

    public SimpleParser<T> createSimpleParser() {
        return this.createParser();
    }

    private ParserErrorRecoveryPolicy<T, N, P, V> createDefaultParserErrorRecoveryPolicy() {
        T error = this.table.getErrorTerminal();
        if (error == null || this.parserErrorRecoveryListener == null) {
            return this.createNoErrorRecoveryPolicy();
        }
        return new DefaultParserErrorRecoveryPolicy(this.parserErrorRecoveryListener);
    }

    protected ParserErrorRecoveryPolicy<T, N, P, V> createNoErrorRecoveryPolicy() {
        return ParserErrorRecoveryPolicy.getNoErrorRecoveryPolicy(new DefaultParserWarningReporter());
    }

    public ParserBuilder<T, N, P, V> setParserErrorRecoveryListener(ErrorRecoveryListener<? super T, ? super N> errorRecoveryListener) {
        if (this.table.getErrorTerminal() == null) {
            throw new IllegalStateException("the grammar file doesn't define an error terminal");
        }
        this.parserErrorRecoveryListener = errorRecoveryListener;
        return this;
    }

    public ParserBuilder<T, N, P, V> setParserListener(ParserListener<? super T, ? super N, ? super P> listener) {
        this.listener = listener;
        return this;
    }

    public ParserBuilder<T, N, P, V> setBranchingParserListener(BranchingParserListener<? super T> branchingListener) {
        this.branchingListener = branchingListener;
        return this;
    }

    public ParserBuilder<T, N, P, V> setLookaheadMap(LookaheadMap<? extends T, ? super V> lookaheadMap) {
        this.lookaheadMap = lookaheadMap;
        return this;
    }

    public ParserBuilder<T, N, P, V> setHashLookaheadMap() {
        this.lookaheadMap = LookaheadMapFactory.hashLookaheadMap(this.table);
        return this;
    }

    public static <T extends Enum<T>, N, P, V extends Enum<V>> ParserBuilder<T, N, P, V> setEnumLookaheadMap(ParserBuilder<T, N, P, V> builder) {
        builder.lookaheadMap = LookaheadMapFactory.enumLookaheadMap(builder.table);
        return builder;
    }

    public ParserBuilder<T, N, P, V> setParserErrorRecoveryPolicy(ParserErrorRecoveryPolicy<T, N, P, V> policy) {
        this.policy = policy;
        return this;
    }

    public ParserBuilder<T, N, P, V> setStart(N start) {
        this.start = start;
        return this;
    }

    public ParserBuilder<T, N, P, V> setVersion(V version) {
        this.version = version;
        return this;
    }

    public ErrorRecoveryListener<? super T, ? super N> getErrorRecoveryListener() {
        return this.parserErrorRecoveryListener;
    }

    public ParserListener<? super T, ? super N, ? super P> getParserListener() {
        return this.listener;
    }

    public BranchingParserListener<? super T> getBranchingParserListener() {
        return this.branchingListener;
    }

    public LookaheadMap<? extends T, ? super V> getLookaheadMap() {
        return this.lookaheadMap;
    }

    public ParserErrorRecoveryPolicy<T, N, P, V> getParserErrorRecoveryPolicy() {
        return this.policy;
    }

    public N getStart() {
        return this.start;
    }

    public ParserTable<T, N, P, V> getParserTable() {
        return this.table;
    }

    public V getVersion() {
        return this.version;
    }
}

