/*
 * Decompiled with CFR 0.152.
 */
package fr.umlv.tatoo.runtime.tools;

import fr.umlv.tatoo.runtime.buffer.LexerBuffer;
import fr.umlv.tatoo.runtime.lexer.ErrorForwarder;
import fr.umlv.tatoo.runtime.lexer.ForwardReturn;
import fr.umlv.tatoo.runtime.lexer.Lexer;
import fr.umlv.tatoo.runtime.lexer.LifecycleHandler;
import fr.umlv.tatoo.runtime.parser.ActionReturn;
import fr.umlv.tatoo.runtime.parser.SimpleParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParserForwarder<T, B extends LexerBuffer>
implements ErrorForwarder<B>,
LifecycleHandler<B> {
    private final SimpleParser<T> parser;

    public ParserForwarder(SimpleParser<T> parser) {
        this.parser = parser;
    }

    @Override
    public ForwardReturn forwardUnexpectedCharacter(Lexer<B> lexer) {
        lexer.getBuffer().reset();
        ActionReturn ret = this.parser.branchOnError(null, "lexer forward error");
        assert (ret != ActionReturn.RELEX) : "cannot ask for relex except after a reduce";
        if (ret == ActionReturn.KEEP) {
            return ForwardReturn.RETRY;
        }
        return ForwardReturn.DISCARD;
    }

    @Override
    public void forwardUnexpectedEndOfFile(Lexer<B> lexer) {
        ActionReturn ret = this.parser.branchOnError(this.parser.getTable().getEof(), "lexer eof forward error");
        if (ret == ActionReturn.KEEP) {
            throw new IllegalStateException("policy should not return KEEP on end-of-input");
        }
    }

    @Override
    public void handleReset(Lexer<B> lexer) {
        this.parser.reset();
    }

    @Override
    public void handleClose(Lexer<B> lexer) {
        this.parser.close();
    }
}

