/*
 * Decompiled with CFR 0.152.
 */
package fr.umlv.tatoo.runtime.tools;

import fr.umlv.tatoo.runtime.util.IntArrayList;
import java.util.ArrayList;

public class GenericStack {
    private final IntArrayList primitiveStack;
    private final ArrayList<Object> objectStack;

    public GenericStack(int capacity) {
        this.objectStack = new ArrayList(capacity);
        this.primitiveStack = new IntArrayList(capacity);
    }

    public void push_Object(Object value) {
        this.objectStack.add(value);
    }

    public Object pop_Object() {
        return this.objectStack.remove(this.objectStack.size() - 1);
    }

    public void push_int(int value) {
        this.primitiveStack.add(value);
    }

    public int pop_int() {
        return this.primitiveStack.removeLast();
    }

    public void push_float(float value) {
        this.push_int(Float.floatToIntBits(value));
    }

    public float pop_float() {
        return Float.intBitsToFloat(this.pop_int());
    }

    public void push_char(char value) {
        this.push_int(value);
    }

    public char pop_char() {
        return (char)this.pop_int();
    }

    public void push_short(short value) {
        this.push_int(value);
    }

    public short pop_short() {
        return (short)this.pop_int();
    }

    public void push_byte(byte value) {
        this.push_int(value);
    }

    public byte pop_byte() {
        return (byte)this.pop_int();
    }

    public void push_boolean(boolean value) {
        this.push_int(value ? 1 : 0);
    }

    public boolean pop_boolean() {
        return this.pop_int() != 0;
    }

    public void push_long(long value) {
        this.push_int((int)(value & 0xFFFFFFFFFFFFFFFFL));
        this.push_int((int)(value >> 32 & 0xFFFFFFFFFFFFFFFFL));
    }

    public long pop_long() {
        return (long)this.pop_int() << 32 | (long)this.pop_int();
    }

    public void push_double(double value) {
        this.push_long(Double.doubleToLongBits(value));
    }

    public double pop_double() {
        return Double.longBitsToDouble(this.pop_long());
    }
}

