/*
 * Decompiled with CFR 0.152.
 */
package fr.umlv.tatoo.runtime.tools;

import fr.umlv.tatoo.runtime.lexer.RuleActivator;
import fr.umlv.tatoo.runtime.parser.LookaheadMap;
import fr.umlv.tatoo.runtime.parser.Parser;
import fr.umlv.tatoo.runtime.parser.ParserTable;
import fr.umlv.tatoo.runtime.util.ReadOnlyIntStack;
import java.util.Collection;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnumParserLookaheadActivator<R extends Enum<R>, T extends Enum<T>, V extends Enum<V>>
implements RuleActivator<R> {
    private final ReadOnlyIntStack stateStack;
    private final EnumMap<V, EnumSet<R>[]> rulesArrayMap;
    private final Parser<T, ?, ?, V> parser;
    private final Collection<R> allRules;

    public EnumParserLookaheadActivator(Parser<T, ?, ?, V> parser, EnumMap<T, EnumSet<R>> terminalMap, Class<R> ruleClass, EnumSet<R> unconditionalRules) {
        LookaheadMap<T, Enum> map = parser.getLookaheadMap();
        if (parser.getLookaheadMap() == null) {
            throw new IllegalArgumentException("The parser must be constructed with a lookahead map");
        }
        this.allRules = EnumSet.allOf(ruleClass);
        ParserTable<T, ?, ?, V> table = parser.getTable();
        int stateNb = table.getStateNb();
        Class versionClass = ((Enum)table.getDefaultVersion()).getDeclaringClass();
        EnumMap rulesArrayMap = new EnumMap(versionClass);
        for (Enum version : table.getVersions()) {
            EnumSet[] rulesArray = new EnumSet[stateNb];
            for (int state = 0; state < stateNb; ++state) {
                EnumSet<R> rules = EnumSet.noneOf(ruleClass);
                rules.addAll(unconditionalRules);
                for (Enum terminal : map.getLookahead(state, version)) {
                    Set toAdd = terminalMap.get(terminal);
                    if (toAdd == null) continue;
                    rules.addAll(toAdd);
                }
                rulesArray[state] = rules;
            }
            rulesArrayMap.put(version, rulesArray);
        }
        this.parser = parser;
        this.rulesArrayMap = rulesArrayMap;
        this.stateStack = parser.getStateStack();
    }

    @Override
    public Iterable<? extends R> activeRules() {
        return this.rulesArrayMap.get(this.parser.getVersion())[this.stateStack.last()];
    }

    @Override
    public Iterable<? extends R> allRules() {
        return this.allRules;
    }
}

