/*
 * Decompiled with CFR 0.152.
 */
package fr.umlv.tatoo.runtime.parser;

import fr.umlv.tatoo.runtime.parser.ActionReturn;
import fr.umlv.tatoo.runtime.parser.Parser;
import fr.umlv.tatoo.runtime.parser.ParserWarningReporter;
import fr.umlv.tatoo.runtime.util.IntArrayList;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ParserErrorRecoveryPolicy<T, N, P, V> {
    public abstract boolean errorRecoveryNeedsContinuation();

    public abstract ActionReturn recoverOnError(Parser<T, N, P, V> var1, IntArrayList var2, T var3, String var4);

    public abstract ActionReturn continueRecoverOnError(Parser<T, N, P, V> var1, IntArrayList var2, T var3);

    public abstract boolean closeParser(Parser<T, N, P, V> var1);

    public abstract Set<? extends T> getLookahead(Parser<T, N, P, V> var1, Set<? extends T> var2);

    public abstract void reset();

    public static <T, N, P, V> ParserErrorRecoveryPolicy<T, N, P, V> getNoErrorRecoveryPolicy(final ParserWarningReporter<T, N, P, V> warningReporter) {
        return new ParserErrorRecoveryPolicy<T, N, P, V>(){

            @Override
            public boolean closeParser(Parser<T, N, P, V> parser) {
                return true;
            }

            @Override
            public ActionReturn continueRecoverOnError(Parser<T, N, P, V> parser, IntArrayList states, T terminal) {
                throw new AssertionError((Object)"no continuation needed");
            }

            @Override
            public ActionReturn recoverOnError(Parser<T, N, P, V> parser, IntArrayList states, T terminal, String message) {
                if (warningReporter != null) {
                    warningReporter.handleWarning(parser, terminal, message);
                }
                return ActionReturn.NEXT_ERROR;
            }

            @Override
            public Set<? extends T> getLookahead(Parser<T, N, P, V> parser, Set<? extends T> proposedLookaheads) {
                return proposedLookaheads;
            }

            @Override
            public void reset() {
            }

            @Override
            public boolean errorRecoveryNeedsContinuation() {
                return false;
            }
        };
    }
}

