/*
 * Decompiled with CFR 0.152.
 */
package fr.umlv.tatoo.runtime.lexer.rules;

import fr.umlv.tatoo.runtime.buffer.LexerBuffer;
import fr.umlv.tatoo.runtime.lexer.LexerTable;
import fr.umlv.tatoo.runtime.lexer.rules.Action;
import fr.umlv.tatoo.runtime.lexer.rules.ProcessReturn;
import fr.umlv.tatoo.runtime.lexer.rules.RuleData;
import fr.umlv.tatoo.runtime.util.IntArrayList;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActionProcessor<R> {
    int maxVal;
    private int minPriority;
    private Action<R> winningAction;
    private final IntArrayList priorities;
    private final Action<R>[] actions;
    private final LexerTable<R> lexerTable;

    public ActionProcessor(LexerTable<R> lexerTable) {
        int length = lexerTable.getRuleDataMap().size();
        this.actions = new Action[length];
        for (int i = 0; i < length; ++i) {
            this.actions[i] = new Action();
        }
        this.priorities = new IntArrayList();
        this.lexerTable = lexerTable;
    }

    public void reset() {
        this.priorities.clear();
    }

    private void initProcesses(boolean newLine, Iterable<? extends R> rules) {
        this.maxVal = -1;
        this.minPriority = Integer.MAX_VALUE;
        this.priorities.clear();
        int i = 0;
        Map<R, RuleData> ruleDataMap = this.lexerTable.getRuleDataMap();
        for (R r : rules) {
            RuleData ruleData = ruleDataMap.get(r);
            if (!newLine && ruleData.beginningOfLineRequired()) continue;
            this.actions[i].reset(r, ruleData);
            this.priorities.add(i);
            ++i;
        }
    }

    private void removeProcess(int i) {
        int max = this.priorities.size() - 1;
        if (i != max) {
            Action<R> tmp = this.actions[i];
            this.actions[i] = this.actions[max];
            this.actions[max] = tmp;
            this.priorities.set(i, this.priorities.get(max));
        }
        this.priorities.removeLast(1);
    }

    private void updateWinner(int i) {
        Action<R> action = this.actions[i];
        int lastMatch = action.lastMatch();
        if (lastMatch == -1) {
            return;
        }
        int priority = this.priorities.get(i);
        if (lastMatch > this.maxVal || lastMatch == this.maxVal && priority < this.minPriority) {
            this.maxVal = lastMatch;
            this.minPriority = priority;
            this.winningAction = action;
        }
    }

    private void stepProcesses(int step) {
        int i = 0;
        while (i < this.priorities.size()) {
            Action<R> action = this.actions[i];
            if (!action.step(step)) {
                this.updateWinner(i);
                this.removeProcess(i);
                continue;
            }
            ++i;
        }
    }

    public ProcessReturn step(LexerBuffer buffer, Iterable<? extends R> rules) {
        if (this.processFinished()) {
            this.initProcesses(buffer.previousWasNewLine(), rules);
        }
        while (buffer.hasRemaining()) {
            int step = buffer.next();
            this.stepProcesses(step);
            if (!this.priorities.isEmpty()) continue;
            if (this.maxVal == -1) {
                return ProcessReturn.ERROR;
            }
            return ProcessReturn.TOKEN;
        }
        return ProcessReturn.MORE;
    }

    public ProcessReturn stepClose() {
        if (this.processFinished()) {
            return ProcessReturn.NOTHING;
        }
        for (int i = 0; i < this.priorities.size(); ++i) {
            this.updateWinner(i);
        }
        this.priorities.clear();
        if (this.maxVal == -1) {
            return ProcessReturn.ERROR;
        }
        return ProcessReturn.TOKEN;
    }

    boolean processFinished() {
        return this.priorities.isEmpty();
    }

    public R winningRule() {
        if (!this.processFinished() || this.maxVal == -1) {
            throw new IllegalStateException("This method must be called only after a succesfull match");
        }
        return this.winningAction.getRule();
    }

    public int tokenLength() {
        if (!this.processFinished() || this.maxVal == -1) {
            throw new IllegalStateException("This method must be called only after a succesfull match");
        }
        return this.maxVal;
    }

    public LexerTable<R> getLexerTable() {
        return this.lexerTable;
    }
}

