/*
 * Decompiled with CFR 0.152.
 */
package fr.umlv.tatoo.runtime.lexer;

import fr.umlv.tatoo.runtime.buffer.LexerBuffer;
import fr.umlv.tatoo.runtime.buffer.LocationProvider;
import fr.umlv.tatoo.runtime.lexer.Lexer;
import fr.umlv.tatoo.runtime.lexer.LexerWarningReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultLexerWarningReporter<B extends LexerBuffer>
implements LexerWarningReporter<B> {
    public static String formatMessage(Lexer<?> lexer, String message) {
        Object buffer = lexer.getBuffer();
        int character = buffer.lastChar();
        String firstPart = character == -1 ? message : String.format("%s \"%c\" (%d)", message, Character.valueOf((char)character), character);
        LocationProvider location = buffer.getLocationProvider();
        if (location != null) {
            return String.format("%s at %s at %s", firstPart, DefaultLexerWarningReporter.interval("line", location.getUnwindedLineNumber(), location.getLineNumber()), DefaultLexerWarningReporter.interval("column", location.getUnwindedColumnNumber(), location.getColumnNumber()));
        }
        return firstPart;
    }

    private static String interval(String name, int from, int to) {
        if (from == to) {
            return String.format("%s %d", name, from);
        }
        return String.format("%ss %d-%d", name, from, to);
    }

    @Override
    public void handleWarning(Lexer<? extends B> lexer, String message) {
        System.err.println(DefaultLexerWarningReporter.formatMessage(lexer, message));
    }
}

