/*
 * Decompiled with CFR 0.152.
 */
package fr.umlv.tatoo.runtime.buffer.impl;

import fr.umlv.tatoo.runtime.buffer.TokenBuffer;
import fr.umlv.tatoo.runtime.buffer.impl.AbstractBufferWrapper;
import fr.umlv.tatoo.runtime.buffer.impl.LocationTracker;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReadableWrapper
extends AbstractBufferWrapper
implements TokenBuffer<CharBuffer> {
    private CharBuffer buffer;
    private CharBuffer tokenBuffer;
    boolean newLine = true;
    private final Readable readable;
    private final int increment;
    private final int chunkSize;
    private final boolean direct;

    public ReadableWrapper(Readable readable, LocationTracker tracker) {
        this(true, 1000, 100, 100, readable, tracker);
    }

    public ReadableWrapper(boolean direct, int capacity, int increment, int chunkSize, Readable readable, LocationTracker tracker) {
        super(tracker);
        this.readable = readable;
        this.increment = Math.max(chunkSize, increment);
        this.chunkSize = chunkSize;
        this.direct = direct;
        this.allocateBuffer(capacity + 1);
        this.buffer.limit(1);
        this.buffer.put('\n');
        this.tokenBuffer = this.buffer.duplicate();
    }

    private void allocateBuffer(int capacity) {
        this.buffer = this.direct ? ByteBuffer.allocateDirect(2 * capacity).asCharBuffer() : CharBuffer.allocate(capacity);
    }

    @Override
    protected void resetImpl() {
        this.buffer.position(this.tokenBuffer.limit());
    }

    @Override
    protected void unwindImpl(int l) {
        int tokenLimit = this.tokenBuffer.limit() + l;
        this.tokenBuffer.limit(tokenLimit);
        this.buffer.position(tokenLimit - 1);
        char lastChar = this.buffer.get();
        this.newLine = lastChar == '\n' || lastChar == '\r';
    }

    @Override
    public boolean previousWasNewLine() {
        return this.newLine;
    }

    @Override
    public boolean hasRemaining() {
        return this.buffer.hasRemaining();
    }

    @Override
    public boolean read() throws IOException {
        if (this.hasRemaining()) {
            return true;
        }
        this.ensureCapacity();
        this.buffer.mark();
        int read = this.readable.read(this.buffer);
        this.buffer.limit(this.buffer.position());
        this.buffer.reset();
        return read != -1;
    }

    private void ensureCapacity() {
        int n = this.chunkSize;
        if (this.buffer.capacity() > this.buffer.position() + n) {
            this.buffer.limit(this.buffer.capacity());
            return;
        }
        int tokenStartMinusOne = this.tokenBuffer.position() - 1;
        int tokenLimit = this.tokenBuffer.limit();
        if (this.buffer.capacity() > this.buffer.position() + n - tokenStartMinusOne) {
            this.buffer.position(tokenStartMinusOne);
            this.buffer.compact();
            this.tokenBuffer.position(1);
            this.tokenBuffer.limit(tokenLimit - tokenStartMinusOne);
            return;
        }
        CharBuffer oldBuffer = this.buffer;
        this.allocateBuffer(oldBuffer.capacity() + this.increment);
        oldBuffer.position(tokenStartMinusOne);
        this.buffer.put(oldBuffer);
        this.tokenBuffer = this.buffer.duplicate();
        this.tokenBuffer.position(1);
        this.tokenBuffer.limit(tokenLimit - tokenStartMinusOne);
    }

    @Override
    protected int nextImpl() {
        return this.buffer.get();
    }

    @Override
    protected void discardImpl() {
        this.tokenBuffer.position(this.tokenBuffer.limit());
    }

    @Override
    protected void restartImpl() {
        int position = this.tokenBuffer.position();
        this.tokenBuffer.position(position - 1);
        this.newLine = ReadableWrapper.isEoln(this.tokenBuffer.get());
        this.tokenBuffer.limit(position);
        this.buffer.position(this.tokenBuffer.position());
    }

    @Override
    public CharBuffer view() {
        return this.tokenBuffer;
    }

    public String toString() {
        return this.tokenBuffer.toString();
    }

    @Override
    public int lastChar() {
        if (this.buffer.position() == 0) {
            return -1;
        }
        return this.buffer.get(this.buffer.position() - 1);
    }
}

