/*
 * Decompiled with CFR 0.152.
 */
package fr.umlv.tatoo.runtime.buffer.impl;

import fr.umlv.tatoo.runtime.buffer.LocationProvider;
import fr.umlv.tatoo.runtime.util.IntArrayList;

public class LocationTracker
implements LocationProvider {
    private final IntArrayList newLines = new IntArrayList();
    private int columnNumber;
    private int lineNumber;
    private int unwindedColumnNumber;
    private int unwindedLineNumber;
    private int advance;

    public void bufferNext(int character) {
        ++this.advance;
        if (character == 10) {
            this.newLines.add(this.advance);
            this.columnNumber = 0;
            ++this.lineNumber;
        } else {
            ++this.columnNumber;
        }
    }

    public void bufferUnwind(int count) {
        int offset = this.findGreatestLessThan(count);
        if (offset != -1) {
            this.unwindedColumnNumber = count - this.newLines.get(offset);
            this.unwindedLineNumber += offset + 1;
        } else {
            this.unwindedColumnNumber += count;
        }
        this.columnNumber = this.unwindedColumnNumber;
        this.lineNumber = this.unwindedLineNumber;
        this.advance = 0;
        this.newLines.clear();
    }

    private int findGreatestLessThan(int l) {
        if (this.newLines.isEmpty() || this.newLines.get(0) > l) {
            return -1;
        }
        int min = 0;
        int max = this.newLines.size() - 1;
        while (min != max) {
            int average = (min + max + 1) / 2;
            int value = this.newLines.get(average);
            if (value > l) {
                max = average - 1;
                continue;
            }
            min = average;
        }
        return min;
    }

    public void bufferReset() {
        this.newLines.clear();
        this.advance = 0;
        this.unwindedColumnNumber = this.columnNumber;
        this.unwindedLineNumber = this.lineNumber;
    }

    public void bufferClear() {
        this.newLines.clear();
        this.advance = 0;
        this.columnNumber = 0;
        this.unwindedColumnNumber = 0;
        this.lineNumber = 0;
        this.unwindedLineNumber = 0;
    }

    public int getColumnNumber() {
        return this.columnNumber;
    }

    public void setColumnNumber(int columnNumber) {
        this.columnNumber = columnNumber;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public void setLineNumber(int lineNumber) {
        this.lineNumber = lineNumber;
    }

    public int getUnwindedColumnNumber() {
        return this.unwindedColumnNumber;
    }

    public void setUnwindedColumnNumber(int unwindedColumnNumber) {
        this.unwindedColumnNumber = unwindedColumnNumber;
    }

    public int getUnwindedLineNumber() {
        return this.unwindedLineNumber;
    }

    public void setUnwindedLineNumber(int unwindedLineNumber) {
        this.unwindedLineNumber = unwindedLineNumber;
    }

    public void bufferRestart() {
    }

    public void bufferDiscard() {
    }
}

