/*
 * Decompiled with CFR 0.152.
 */
package fr.umlv.tatoo.runtime.buffer.impl;

import fr.umlv.tatoo.runtime.buffer.LexerBuffer;
import fr.umlv.tatoo.runtime.buffer.impl.LocationTracker;

public abstract class AbstractBufferWrapper
implements LexerBuffer {
    private final LocationTracker locationTracker;

    public AbstractBufferWrapper(LocationTracker locationTracker) {
        this.locationTracker = locationTracker;
    }

    protected abstract void unwindImpl(int var1);

    public final void unwind(int count) {
        this.unwindImpl(count);
        if (this.locationTracker != null) {
            this.locationTracker.bufferUnwind(count);
        }
    }

    protected abstract void discardImpl();

    public final void discard() {
        this.discardImpl();
        if (this.locationTracker != null) {
            this.locationTracker.bufferDiscard();
        }
    }

    protected abstract void restartImpl();

    public final void restart() {
        this.restartImpl();
        if (this.locationTracker != null) {
            this.locationTracker.bufferRestart();
        }
    }

    protected abstract int nextImpl();

    public final int next() {
        int character = this.nextImpl();
        if (this.locationTracker != null) {
            this.locationTracker.bufferNext(character);
        }
        return character;
    }

    protected abstract void resetImpl();

    public final void reset() {
        this.resetImpl();
        if (this.locationTracker != null) {
            this.locationTracker.bufferReset();
        }
    }

    protected final void locationClear() {
        if (this.locationTracker != null) {
            this.locationTracker.bufferClear();
        }
    }

    public LocationTracker getLocationProvider() {
        return this.locationTracker;
    }

    static boolean isEoln(int c) {
        return c == 10 || c == 13;
    }
}

